package easik.ui.menu.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import org.jgraph.graph.DefaultGraphCell;

import easik.Easik;
import easik.sketch.Sketch;
import easik.sketch.edge.SketchEdge;
import easik.sketch.path.SketchPath;
import easik.sketch.vertex.EntityNode;
import easik.states.LoadingState;

/**
 * Action for the rename option in the popup menu.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-07-26 Kevin Green
 */
public class RenameAction extends AbstractAction {
		
	/**
	 * Sets up rename action
	 */
	public RenameAction( ) {		
		super("Rename ...");	
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_R));
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Change the name of selection");
	}
	
	/**
	 * Called when clicked upon, will rename an article. 
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		Sketch _ourSketch = Easik.getInstance().getFrame().getSketch();
		
		Vector currentSelection = _ourSketch.getSelectionListener().getCurrentSelection();
		EntityNode nodeToRename = null;
		SketchEdge edgeToRename = null;
		
		// If only one entity is selected, then we allow this. We will ignore any
		// non-entities which might be selected
		String originalName = "";
		
		if( currentSelection.size() == 1) {
			if( currentSelection.get(0) instanceof EntityNode ) {												
				nodeToRename = (EntityNode)currentSelection.get(0);
				originalName = nodeToRename.getName();
			} else if ( currentSelection.get(0) instanceof SketchEdge ) {
				edgeToRename = (SketchEdge)currentSelection.get(0);
				originalName = edgeToRename.getName();
			}
		}
			
		if((nodeToRename == null) && (edgeToRename == null)) {		
			JOptionPane.showMessageDialog( _ourSketch.getParent(),
					"Operation must be performed with a single entity or edge selected",
					"Error",
					JOptionPane.ERROR_MESSAGE);
		} else {			
			String s = (String)JOptionPane.showInputDialog(
								_ourSketch.getParent(),
								"New name:", "Rename",
								JOptionPane.QUESTION_MESSAGE,
								null, null, originalName);
			if (s != null) {
				s = s.trim();
				// Is it a node?
				if(nodeToRename != null) {				
					if (s.equals("")){
						JOptionPane.showMessageDialog( _ourSketch.getParent(),
								"Entity name is empty",
								"Error",
								JOptionPane.ERROR_MESSAGE);					
					}
					else if(_ourSketch.isNameUsed(s) && !nodeToRename.getName().equals(s)){
						JOptionPane.showMessageDialog( _ourSketch.getParent(),
								"Entity name is already in use",
								"Error",
								JOptionPane.ERROR_MESSAGE);
					}
					else if(s.equalsIgnoreCase("fail")){
						JOptionPane.showMessageDialog(_ourSketch.getParent(), "The name '"+s+"' is restricted.",
								"Error",
								JOptionPane.ERROR_MESSAGE);
					}
					else{
						//Push loading state
						Easik.getInstance().getStateManager().pushState(new LoadingState());
						
						_ourSketch.getEntities().remove( nodeToRename.getName() );
						nodeToRename.setName( s );
						_ourSketch.getEntities().put( s, nodeToRename );
						
						Easik.getInstance().getFrame().getInfoTreeUI().refreshTree();
						Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().reload();
						
						//Pop state
						Easik.getInstance().getStateManager().popState();
						
						_ourSketch.repaint();
						_ourSketch.setDirty(true);
					}
				} else {
					// Otherwise it is an edge
					if (s.equals("")){
						JOptionPane.showMessageDialog( _ourSketch.getParent(),
								"Edge name is empty",
								"Error",
								JOptionPane.ERROR_MESSAGE);
					}
					else if(_ourSketch.isEdgeNameUsed(s)){
						JOptionPane.showMessageDialog( _ourSketch.getParent(),
								"Edge name is already in use",
								"Error",
								JOptionPane.ERROR_MESSAGE);
					}
					else{
						String oldName = edgeToRename.getName();
						_ourSketch.getEdges().remove( oldName );					
						edgeToRename.setName( s );
						_ourSketch.getEdges().put( s, edgeToRename );
						
						//Renames any paths containing this edge.
						HashMap allPaths = _ourSketch.getPaths();
						SketchPath.renamePaths(allPaths, edgeToRename);
						
						Easik.getInstance().getFrame().getInfoTreeUI().refreshTree();
						Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().reload();
						
						_ourSketch.repaint();
						_ourSketch.setDirty(true);
					} 	
				}
			}			
			
		}	
		
		_ourSketch.getSelectionListener().emptySelection();
	}	
}
